package row_data_gateway;
import db_context.DbContext;
import complex_operations.OtherOperations;
import db_context.MyExceptions;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DriverFinder {
    private static final DriverFinder INSTANCE = new DriverFinder();

    public static DriverFinder getInstance() {
        return INSTANCE;
    }

    private DriverFinder() {
    }

    public Driver SetDriver(ResultSet r) throws SQLException {
        Driver d = new Driver();
        d.setId(r.getInt("id"));
        d.setFirst_name(r.getString("first_name"));
        d.setSecond_name(r.getString("second_name"));
        d.setHire_date(r.getDate("hire_date"));
        d.setSalary(r.getBigDecimal("salary"));
        d.setInitial_salary(r.getBigDecimal("initial_salary"));
        d.setDelivered_packages(r.getInt("delivered_packages"));
        d.setLocation_id(r.getInt("location_id"));
        d.setTransport_id(r.getInt("transport_id"));
        return d;
    }

    public Driver findById(int id) throws SQLException, MyExceptions.NotSuchIdException {

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM drivers WHERE id = ?")){
            s.setInt(1, id);
            try (ResultSet r = s.executeQuery()) {
                if (r.next()) {
                    Driver d = SetDriver(r);

                    if(d.getTransport_id() == 0) d.setTransport_id(null);
                    if (r.next()) throw new RuntimeException("Move than one row was returned");
                    return d;
                } else {
                    throw new MyExceptions.NotSuchIdException("No such driver");
                }
            }
        }
    }

    public Driver findByTransportId(int t_id) throws SQLException, MyExceptions.NotSuchIdException {

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM drivers WHERE transport_id = ?")){
            s.setInt(1, t_id);
            try (ResultSet r = s.executeQuery()) {
                if (r.next()) {
                    Driver d = SetDriver(r);

                    if(d.getTransport_id() == 0) d.setTransport_id(null);
                    if (r.next()) throw new RuntimeException("Move than one row was returned");
                    return d;
                } else {
                    throw new MyExceptions.NotSuchIdException("This transport has no driver or doesnt exists");
                }
            }
        }
    }

    public void printDriver(Driver driver) throws SQLException, MyExceptions.NotSuchIdException {
        System.out.print("first name:         "); System.out.println(driver.getFirst_name());
        System.out.print("second name:        "); System.out.println(driver.getSecond_name());
        System.out.print("hire date:          "); System.out.println(driver.getHire_date());
        System.out.print("salary:             "); System.out.println(driver.getSalary()+"€");
        System.out.print("delivered packages: "); System.out.println(driver.getDelivered_packages());
        System.out.print("location:           "); System.out.println(OtherOperations.getInstance().findLocationNameById(driver.getLocation_id()));
        System.out.print("transport id:       "); System.out.println(driver.getTransport_id());
    }
}
